function code = encode(x)
    
  N = numel(x(:)) ;
  
  if (N==0)
    % cas de la chaine vide
     
    code = [] ;
    
  else
    
    m1 = min(x) ;
    m2 = max(x) ;
    
    % calcul des valeurs qui apparaissent dans x et de leur frequence
    x2 = sort([x(:);[m1:m2]'],'ascend') ;
    inds = find(x2~=[x2(2:end);m2+1]) ;
    nb_occ = inds - [0;inds(1:end-1)] - 1 ;
    ind_vals = find(nb_occ) ;
    vals = m1-1 + ind_vals ;
    probas = nb_occ(ind_vals) / N ;
    
    % calcul du code de huffman associe et d'une chaine de
    % caracteres, table_code, decrivant la table
    [table,table_code] = huffman_table(probas) ;
    
    % calcul du code associe a x
    trad = zeros(1,m2-m1+1) ;
    trad(ind_vals) = [1:numel(ind_vals)] ;
    code = table(trad(x-m1+1)) ;
    code = [code{:}] ;
    
    if (numel(vals) == 1)
      % cas particulier : si tous les elements de x sont egaux,
      % le code est simplement la representation binaire du
      % nombre d'elements
      code = dec2bin(N) ;
    end
    
    % chaine de caracteres decrivant les valeurs presentes dans x
    vals_code = list_code(vals) ;
    
    % concatenantion du code et des deux chaines de caracteres
    % decrivant la methode d'encodage (ce qui permettra de decoder)
    code = cat_code(vals_code,table_code,code) ;

end
    

function code = list_code(v)
% calcule un code associe a une suite d'entiers distincts
% la suite renvoyee est a peu pres la suite des representations
% binaires des entiers, avec des separateurs entre les entiers
    
  v = arrayfun(@(t)(['2',char(48+(t>=0)), ...
                     dec2bin(abs(t))]), ...
               v,'UniformOutput',0) ;
  v = [v{:}] ;
  code = zeros(1,2*numel(v)) ;
  code(1:2:end) = (v=='2') ;
  code(2:2:end) = (v~='0') ;
  code = char(48+code) ;

  % ajout de zeros au debut pour que la taille du code soit un
  % multiple de 8
  leng = numel(code) ;
  n = 8*ceil(leng/8) ;
  code = [char(48*ones(1,n-leng)),code] ;
    

function [codes,table_code] = huffman_table(probas)
% calcul du code de huffman associe a une distribution de probabilites
    
  N = numel(probas) ;
  inds = num2cell([1:N]) ;
  codes = cell(1,N) ;

  % construction de l'arbre
  for n=1:N-1
    
    [p1,k1] = min(probas) ;
    probas(k1) = Inf ;
    [p2,k2] = min(probas) ;
    probas(k2) = p1+p2 ;
    probas(k1) = [] ;

    codes(inds{k1}) = pref(codes(inds{k1}),'1') ;
    codes(inds{k2}) = pref(codes(inds{k2}),'0') ;

    
    inds{k2} = [inds{k1},inds{k2}] ;
    inds = {inds{1:k1-1},inds{k1+1:end}} ;
    
  end

  % calcul du code decrivant la table il s'agit de la suite des codes,
  % avec des separateurs
  aux = pref(codes,'2') ;
  aux = [aux{:}] ;
  s_aux = numel(aux) ;
  ind1 = find(aux=='1') ;
  ind2 = find(aux=='2') ;
  table_code = char(48*ones(1,2*s_aux)) ;
  table_code(2*ind2-1) = '1' ;
  table_code(2*ind2) = '1' ;
  table_code(2*ind1) = '1' ;

  % ajout de zeros au debut pour que la taille du code soit un
  % multiple de 8
  n = 8*ceil(s_aux/4) ;
  table_code = [char(48*ones(1,n-2*s_aux)),table_code] ;


function cell2 = pref(cell1,c)

  cell2 = cellfun(@(s)([c,s]),cell1,'UniformOutput',0) ;


function code = cat_code(code1,code2,code3)
% concatenation (avec ajout de 0s et de 1s toutes les huit
% positions, de facon a pouvoir separer les trois morceaux au
% decodage)
    
  n1 = numel(code1)/8 ;
  n2 = numel(code2)/8 ;

  code1_bis = char(48*ones(1,9*n1)) ;
  code2_bis = char(48*ones(1,9*n2)) ;

  code1_bis(mod([1:9*n1],9)~=0) = code1 ;
  code1_bis(9*n1) = '1' ;
  code2_bis(mod([1:9*n2],9)~=0) = code2 ;
  code2_bis(9*n2) = '1' ;

  code = [code1_bis,code2_bis,code3] ;

