function f = inverse_wavelet_transform(a)

  % 3.c)
	 
  if (numel(a)==1)
    % Cas N = 1
    f = a ;
  else
    % Cas N > 1
    N = size(a,1) ;

    % Reconstruction de f tilde
    ft = inverse_wavelet_transform(a(1:N/2,1:N/2)) ;
    % Calcul de g a partir de f tilde
    g = zeros(2*size(ft)) ;
    g(1:2:end,1:2:end) = ft ;
    g(2:2:end,1:2:end) = ft ;
    g(1:2:end,2:2:end) = ft ;
    g(2:2:end,2:2:end) = ft ;
    g = g / 2 ;

    % Calcul de h
    h = zeros(size(g)) ;
    a_last(:,:,1) = a(1:N/2,N/2+1:N) ;
    a_last(:,:,2) = a(N/2+1:N,1:N/2) ;
    a_last(:,:,3) = a(N/2+1:N,N/2+1:N) ;
    h(1:2:end,1:2:end) = 0.5 * ...
			 (a_last(:,:,1) + a_last(:,:,2) + a_last(:,:,3)) ;
    h(2:2:end,1:2:end) = 0.5 * ...
			 (a_last(:,:,1) - a_last(:,:,2) - a_last(:,:,3)) ;
    h(1:2:end,2:2:end) = 0.5 * ...
			 (-a_last(:,:,1) + a_last(:,:,2) - a_last(:,:,3)) ;
    h(2:2:end,2:2:end) = 0.5 * ...
			 (-a_last(:,:,1) - a_last(:,:,2) + a_last(:,:,3)) ;

    % Calcul de f
    f = g + h ;
  end

