function a = wavelet_transform(f)

  % 2.h)
				     
  % On verifie que f est bien de la forme NxN avec N une puissance
  % de 2
  [N1,N2] = size(f) ;
  if (N1 ~= N2)
    error('wavelet_transform: l image doit etre carree') ;
  else
    J = log(N1)/log(2) ;
    if (abs(J-round(J))>1e-10)
       error(['wavelet_transform: le cote de l image doit ', ...
	      'etre une puissance de 2']) ;
    end
    J = round(J) ;
  end

  if (J==0)
    % Cas N=1 : la base n a qu un seul element, phi. Le coefficient
    % associe est f
    a = f ;
  else
    % Calcul de f tilde et des a_(s,1)
    [a_last,ft] = last_scale(f) ;
    % Calcul des autres coefficients par recurrence
    a = wavelet_transform(ft) ;
    % Concatenation des coefficients en un seul tableau
    a = [a,a_last(:,:,1);a_last(:,:,2),a_last(:,:,3)] ;
  end
