function [im_comp,H] = compress(delta,im)
  % Compresse une image avec pas de quantification delta

  % 4.a) transformee en ondelettes
  a = wavelet_transform(im) ;
  % 4.b) concatenation des coefficients
  v = a(:) ;
  % 4.c) quantification
  v_quant = delta * round(v/delta) ;
  % 4.d) encodage
  im_comp = encode(round(v/delta)) ;

  % 4.e) calcul de l entropie
  % nombre d occurences de chaque valeur
  n_occ = hist(v_quant/delta,[min(v_quant/delta)-1:max(v_quant/delta)]) ;
  % suppression des valeurs sans occurrence
  n_occ = n_occ(find(n_occ)) ;
  % on en deduit la probabilite de chaque valeur
  probas = n_occ / sum(n_occ) ;
  % calcul de l entropie
  H = sum(-probas .* log(probas)/log(2)) ;
