function message = decode(x)
    
  N = numel(x) ;

  if (N==0)
    % cas du code vide
    
    message = [] ;
    
  else
    % on decoupe le code en trois morceaux ; le premier indique la
    % liste des valeurs, le deuxieme la table de huffman utilisee et
    % le troisieme est le code a proprement parler
    ind = find(x(9:9:N)=='1') ;
    
    vals_code = x(1:9*ind(1)) ;
    vals_code(9:9:9*ind(1)) = [] ;
    vals = decode_list(vals_code) ;
    m = length(vals) ;
    
    table_code = x(9*ind(1)+1:9*ind(2)) ;
    table_code(9:9:end) = [] ;
    table = decode_table(table_code,m) ;
    
    code = x(9*ind(2)+1:end) ;
    
    if (numel(vals)==1)
      % cas ou il n'y a qu'une valeur presente
       
      message = vals * ones(1,bin2dec(code)) ;
        
    else
        
      N = numel(code) ;
        
      % pour chaque position du code, on determine quel serait le
      % premier caractere si le code commencait a cette position et
      % quelle serait la longueur de son code
      symb = zeros(1,N) ;
      leng = Inf*ones(1,N) ;
      for k=1:m
        ind = strfind(code,table{k}) ;
        symb(ind) = vals(k) ;
        leng(ind) = numel(table{k}) ;
      end
        
      next_ind = leng + [1:N] ;
      next_ind(find(next_ind==Inf)) = N+1 ;
      next_ind = [next_ind,N+1] ;
        
      curr_ind = 1 ;
      s = 1 ;
        
      % calcul iteratif du message
      while (curr_ind<N+1)
        message(s) = symb(curr_ind) ;
        s = s+1 ;
        curr_ind = next_ind(curr_ind) ;
      end
    end
  end


function vals = decode_list(code)
% decodage du code representant une liste de valeurs
    
  code = double(code)-48 ;
  code = code(1:2:end)+code(2:2:end) ;

  sep = (code==2) ;
  blocks = cumsum(sep) ;

  for k=1:blocks(end)
    symb = code(find(blocks==k)) ;
    vals(k) = bin2dec(char(48+symb(3:end))) ...
              * (2*symb(2)-1) ;
  end
    

function table = decode_table(table_code,m) ;
% decodage du code representant une table de huffman
    
  code = arrayfun(@str2num,table_code) ;
  code = code(1:2:end) + code(2:2:end) ;

  sep = (code==2) ;
  blocks = cumsum(sep) ;

  for k=1:m
    symb = code(find(blocks==k)) ;
    table{k} = char(48+symb(2:end)) ;
  end
