clear all ; close all ;

% 3.d) Test de la transformee en ondelettes et de son inverse
N = 512 ;
% signal aleatoire
f = randn(N) ;
% transformee en ondelettes
a = wavelet_transform(f) ;
% transformee en ondelettes inverse
f_rec = inverse_wavelet_transform(a) ;
% affichage de l erreur
err = sqrt(sum(abs(f(:)-f_rec(:)).^2)) ;
fprintf('Erreur de reconstruction : %.1e\n',err) ;

% 5.b) Chargement de l image
im = imread('batiment.png') ;
im = sum(im,3) ;
im = im/max(im(:))*255 ;
% 5.c) Tests de compression et decompression
figure (1) ;
imagesc(im,[0,255]) ;
colormap('gray') ; axis equal ; colorbar ;
title('Image originale') ;
figure (2) ;
imagesc(decompress(100,compress(100,im)),[0,255]) ;
colormap('gray') ; axis equal ; colorbar ;
title('Quantification 100') ;
figure (3) ;
imagesc(decompress(30,compress(30,im)),[0,255]) ;
colormap('gray') ; axis equal ; colorbar ;
title('Quantification 30') ;

% 5.d)
deltas = [2,5,10,20,50,100,200,500] ;
for k = 1:numel(deltas)
  [im_comp,H_k] = compress(deltas(k),im) ;
  R(k) = numel(im_comp) / numel(im) ;
  H(k) = H_k ;
  im_rec = decompress(deltas(k),im_comp) ;
  D(k) = sum(abs(im_rec(:)-im(:)).^2) ;
end
figure (4) ; clf ; hold on ;
plot(R,log(D)/log(2)) ;
plot(H,log(D)/log(2),'r') ;
legend('D selon R','D selon H') ;

% 5.h)
fprintf('Encodage de im directement : %.2f bits par pixel\n', ...
	numel(encode(round(im(:))))/numel(im)) ;
