% 1.a) Chargement du signal
[f,freq] = wavread('gemshorn.wav') ;

% 1.b) Taille de la fenetre et nombre de points d'ecart entre
%      chaque position de la fenetre
win_size = round(0.03 *freq) ;
step_size = round(0.005 * freq) ;

% 1.c) Generation de la fenetre
window = hanning(win_size) ;

% 1.k) Transformee de Fourier a fenetre et affichage
S = win_fourier(f,freq,window,step_size,5) ;
figure (1) ;
imagesc(flipud(abs(S))) ;

% 2.e) Calcul des frequences instantanees (premiere version)
S_inst_v1 = inst_freq_v1(S,freq,window,step_size,5) ;
figure (2) ;
imagesc(flipud(S_inst_v1)) ;
colormap('gray') ;

% 2.g) Calcul des frequences instantanees (deuxieme version)
S_inst = inst_freq(S,freq,window,step_size,5) ;
figure (3) ;
imagesc(flipud(S_inst)) ;
colormap('gray') ;

% 2.h) Idem pour chirp.wav
[f,freq] = wavread('chirp.wav') ;
win_size = round(0.03 *freq) ;
step_size = round(0.005 * freq) ;
window = hanning(win_size) ;
S = win_fourier(f,freq,window,step_size,5) ;
S_inst = inst_freq(S,freq,window,step_size,5) ;
figure (4) ;
imagesc(flipud(S_inst)) ;
colormap('gray') ;
