function S = win_fourier(f,freq,window,step_size,ov)

  % 1.e) Accentuation des hautes frequences	 
  g = f(2:end) - f(1:end-1) ;

  % 1.f) Nombre de fenetres
  N = numel(g) ;
  win_size = numel(window) ;
  nb_win = floor((N-win_size)/step_size+1) ;

  % 1.g) Extraction des entrees de g correspondant aux supports
  %      des fenetres
  S = rep_shift(g,win_size,step_size,nb_win) ;

  % 1.h) Multiplication par la fenetre puis fft
  S = bsxfun(@times,S,window) ;
  S = fft(S,win_size*ov,1) ;

  % 1.j) Suppression des frequences superieures a 5000 Hz
  max_freq = floor(5000*ov*win_size/freq + 1) ;
  S = S(1:max_freq,:) ;
