function F = rep_shift(f,win_size,shift_size,nb_win)
  % Entrees :
  % - f : signal de taille N
  % - win_size,shift_size,nb_win : entiers
  % Sortie :
  % - F : matrice avec nb_win colonnes dont la colonne k contient
  %       les entrees de f comprises entre les indices
  %       (k-1)*shift_size + 1 et (k-1)*shift_size + win_size
	 
  f = f(:) ; % f doit etre un vecteur colonne

  inds = repmat([1:win_size].',[1,nb_win]) ...
	 + shift_size * repmat([0:nb_win-1],[win_size,1]) ;
  inds = mod(inds-1,numel(f)) + 1 ;

  F = f(inds) ;
