function S_inst = inst_freq(S,freq,window,step_size,ov)

  % 2.c) Detection des maxima locaux
  S_inst = (abs(S(2:end-1,:))>abs(S(1:end-2,:))) .* ...
	   (abs(S(2:end-1,:))>abs(S(3:end,:))) ;
  S_inst = [zeros(1,size(S,2)) ; S_inst ; zeros(1,size(S,2))] ;

  % 2.d) Seuillage
  S_inst = S_inst .* (abs(S)>0.02*max(abs(S(:)))) ;

  % 2.g) Raffinement du resultat
  quot = S(:,2:end) ./ S(:,1:end-1) ; % quotient
  quot(find(abs(S(:,1:end-1))<1e-10)) = 0 ;
                % au cas ou il y aurait eu des divisions par 0
  quot = quot ./ (abs(quot)+1e-12) ; % on ne s'interesse qu'a la phase ici
  % (le 1e-12 est la pour eviter les eventuelles divisions par 0)
  
  % Calcul de ce que le quotient doit valoir aux points qui
  % correspondent vraiment a des frequences instantanees
  win_size = numel(window) ;
  k = repmat([1:size(S,1)]',[1,size(S,2)-1]) ;
  quot_comp = exp(2*pi*i*step_size/(win_size*ov)*(k-1)) ;

  % Suppression des points ou quot et quot_comp sont trop differents
  S_inst(:,1:end-1) = S_inst(:,1:end-1) ...
		      .* (abs(quot-quot_comp) < 0.2) ;
