% 1.d) affichage d une realisation du processus gaussien
a = 0.1 ;
N = 1000 ;
figure (1) ;
plot(gauss(N,a)) ;

% 2.b) processus bruite
sigma = 0.1 ;
X_a = gauss(N,a) ;
Y = sigma * randn(1,N) ;
D = X_a + Y ;
% 2.c) debruitage par filtrage de Wiener
D_star_h = wiener(D,a,sigma) ;
figure (2) ; clf ; hold on ;
plot(X_a,'b') ;
plot(D,'r') ;
plot(D_star_h,'m') ;
legend('Initial','Bruite','Debruite') ;

% 3.b) processus continu par morceaux
p = 0.995 ;
figure (3) ;
plot(cpm(N,p)) ;

% 3.d) processus bruite
sigma = 0.1 ;
Z = cpm(N,p) ;
Y = sigma * randn(1,N) ;
D = Z + Y ;

% debruitage par filtrage de Wiener
D_star_h = wiener_cpm(D,p,sigma) ;
figure (4) ; clf ; hold on ;
plot(Z,'b') ;
plot(D,'r') ;
 plot(D_star_h,'m') ;
legend('Initial','Bruite','Debruite') ;
% il reste beaucoup de bruit

% debruitage plus energique, avec un sigma plus grand
D_star_h = wiener_cpm(D,p,5*sigma) ;
figure (5) ; clf ; hold on ;
plot(Z,'b') ;
plot(D,'r') ;
 plot(D_star_h,'m') ;
legend('Initial','Bruite','Debruite') ;
% le bruit est plus attenue mais les discontinuites
% commencent a etre lissees
