% 1.a) Chargement de l'image
im = imread('image.png') ;
im = sum(im,3) ; im = im/max(im(:)) ;

% 1.b) Sous-echantillonnage
im_sub = im(1:2:end,1:2:end) ;

% 1.c) Enregistrement
imwrite(im_sub,'im_sub.png') ;

% 1.d) Soustraction de la moyenne
im_mean = im - mean(im(:)) ;
% Transformee de Fourier et module
im_mean_f = abs(fft2(im_mean)) ;
% Affichage
figure (1) ;
imagesc(fftshift(abs(im_mean_f))) ;
colorbar ;

% 1.e) La transformee de Fourier de l'image im n'est pas à support
% inclus dans [-44,44]x[-83,83]. L'image contient des hautes
% frequences non-negligeables. Lorsqu'on sous-echantillonne, on a
% un phenomene de repliement spectral.

% 2.a) Flou local
% La commande circshift(im,[k,l]) decale (circulairement) le
% tableau im de k positions selon la premiere dimension et de l
% positions selon la deuxieme
im_blur_x = 0.25 * circshift(im,[1,0]) + 0.5 * im + ...
    0.25 * circshift(im,[-1,0]) ;
im_blur = 0.25 * circshift(im_blur_x,[0,1]) + 0.5 * im_blur_x + ...
          0.25 * circshift(im_blur_x,[0,-1]) ;

% 2.b) Sous-echantillonnage et enregistrement
im_blur_sub = im_blur(1:2:end,1:2:end) ;
imwrite(im_blur_sub,'im_blur_sub.png') ;

% 3.a) Troncature en frequence
% Definition de la transformee de Fourier de h
hf = zeros(178,336) ;
hf([1:45,135:178],[1:84,254:336]) = 1 ;
% Convolution avec im, en utilisant le fait que la transformee de
% Fourier transforme la convolution en produit
im_trunc = ifft2(hf.*fft2(im)) ;

% 3.b) Projection sur les reels
fprintf(['La partie imaginaire a pour norme %.1e et la partie reelle ' ...
         '%.1e ; la partie imaginaire est bien negligeable\n'], ...
        norm(imag(im_trunc(:))),norm(real(im_trunc(:)))) ;
im_trunc = real(im_trunc) ;

% 3.c) Sous-echantillonnage et enregistrement
im_trunc_sub = im_trunc(1:2:end,1:2:end) ;
imwrite(im_trunc_sub,'im_trunc_sub.png') ;

% 3.d) Amelioration de h
% Les bavures sont dues au fait que le filtre h n'est pas bien
% localise en espace et oscille (c'est un produit de sinus
% cardinaux) et ce sont les oscillations qui provoquent les
% bavures. Pour remedier a cela, il faut definir un filtre h dont
% la transformee de Fourier est plus reguliere (par exemple
% continue ou C^1). Ainsi, h sera mieux localise en espace.

% Je definis : transformee de fourier de h en [k,l] = hx[k]*hy[l],
% avec hx et hy des fonctions "fenetres" assez regulieres

% Definition de hx
hx = [-44:44] ;
hx = (1-(hx/45).^4).^2 ;
hx = [zeros(1,44),hx,zeros(1,45)] ;
hx = circshift(hx,[0,-88]) ;

% Definition de hy
hy = [-83:83] ;
hy = (1-(hy/83).^4).^2 ;
hy = [zeros(1,84),hy,zeros(1,85)] ;
hy = circshift(hy,[0,-167]) ;

% fourier(h)[k,l] = hx[k]*hy[l]
hf_v2 = hx.' * hy ;

% Convolution et partie reelle
im_trunc_v2 = ifft2(hf_v2.*fft2(im)) ;
im_trunc_v2 = real(im_trunc_v2) ;

% Sous-echantillonnage et enregistrement
im_trunc_sub_v2 = im_trunc_v2(1:2:end,1:2:end) ;
imwrite(im_trunc_sub_v2,'im_trunc_sub_v2.png') ;

% Le resultat est un peu plus flou que l'image obtenue dans la
% question 5 mais les oscillations ont quasiment disparu.
