function class = classify(file_name)

  % lecture du fichier
  [f,freq] = wavread(file_name) ;
  freq_out = 10000 ;

  % preprocessing
  f = preprocess(f,freq) ;

  % transformee en ondelettes
  S = wavelet_transform(f,freq,freq_out) ;

  % fonction de detection comme dans la partie 3
  f_dec = sum(abs(S(:,end-15:end)),2) ;  
  f_dec = real(smooth(f_dec,freq_out,0.01)) ;
  f_dec = f_dec(round(0.3*freq_out):end-round(0.3*freq_out)) ;

  step = round(0.01 * freq_out) ;

  % pour des explications sur le fonctionnement de l'algorithme, voir
  % le corrige
  len = floor(numel(f_dec) / freq_out) ;
  quot = [] ;
  for i=1:len
    f_dec_sub = f_dec((i-1)*freq_out+1:i*freq_out) ;
    if (max(f_dec_sub) > 0.3 * max(f_dec))
      pos_var = max(f_dec_sub(step+1:end)-f_dec_sub(1:end-step)) ;
      neg_var = -min(f_dec_sub(step+1:end)-f_dec_sub(1:end-step)) ;
      quot = [quot,pos_var/neg_var] ;
    end
  end
  criterium = mean(quot) ;

  % classification
  if (criterium>1.7)
    class = 'piano' ;
  else
    class = 'violon' ;
  end
