function onsets = detect_onsets(f,freq)

  % 3.b)
  % preprocessing
  f = preprocess(f,freq) ;

  % 3.c)
  % transformee en ondelettes
  freq_out = 10000 ;
  S = wavelet_transform(f,freq,freq_out) ;

  % 3.d)
  % fonction de detection
  f_dec = sum(abs(S),2) ;
  % affichage
  figure ;

  % 3.e)
  % moyennage local
  f_dec = smooth(f_dec,freq_out,0.05) ;
  plot(f_dec) ;

  % 3.f)
  % detection des maxima locaux
  onsets = (f_dec>[0;f_dec(1:end-1)]) .* (f_dec>[f_dec(2:end);0]) ;
  % la valeur doit etre superieure a mean_f + 0.2
  mean_f = smooth(f_dec,freq_out,0.05) ;
  onsets = onsets .* (f_dec>mean_f+0.2) ;  
  % ensemble des indices verifiant les deux conditions
  onsets = find(onsets) ;

  % 3.g)
  % conversion en valeurs temporelles
  onsets = onsets/freq_out ;
