function S = wavelet_transform(f,freq,freq_out)

  N = numel(f) ;

  % 2.b)
  % transformee de Fourier de f
  ff = fft(f) ;
  % indice correspondant a la frequence freq_out
  ind_max = round(N*freq_out/freq + 1) ;
  % troncature
  ff = ff(1:ind_max) ;

  % 2.c)
  % frequences caracteristiques des ondelettes
  f0 = 440 * 2.^(([1:61]-24)/8) ;

  % 2.d)
  %frequences correspondant aux indices de 1 a ind_max
  nu = ([1:ind_max]'-1) * freq / N ;
  % calcul de nu[k]/f0[j]
  nu_f0 = nu * f0.^(-1) ;
  % calcul des ondelettes
  psi = exp(30*i*nu_f0) ./ (1+6*i*(nu_f0-1)).^6 ;

  % 2.e)
  % convolution
  S = bsxfun(@times,psi,ff) ;
  S = ifft(S,[],1) ;
