function f_smooth = smooth(f,freq,T)

  % 1.b)
  % definition du filtre gaussien
  t = [[0:floor(numel(f)/2)], ...
       [floor(-numel(f)/2)+1:-1]]' / freq ;
  filter = exp(-(t/T).^2) ;
  % 1.c)
  % normalisation
  filter = filter / sum(filter) ;

  % 1.d)
  % convolution
  f_smooth = real(ifft(fft(f).*fft(filter))) ;
