function compare(onsets,filename)
  % onsets : liste des positions des notes detectees
  % filename : nom du fichier contenant les vraies positions

  % charge le fichier
  load(filename) ;

  % calcul des performances
  res = compare_impl(onsets,true_onsets) ;

  % affichage
  fprintf('Precision : %.1f %% \n',100*res(1)/(res(1)+res(2))) ;
  fprintf('Recall : %.1f %% \n',100*res(1)/(res(1)+res(3))) ;


function res = compare_impl(l,true_l)
  % renvoie un tableau a trois elements
  % premier element : nombre de notes qui ont bien ete detectees
  % deuxieme element : nombre de detections qui ne correspondent
  %                    pas a des notes
  % troisieme element : nombre de notes qui n'ont pas ete detectees

  if isempty(l)
    res = [0,0,numel(true_l)] ;
  elseif isempty(true_l)
    res = [0,numel(l),0] ;
  else
    if (l(1)<true_l(1)-0.1)
      res = compare_impl(l(2:end),true_l) ;
      res(2) = res(2) + 1 ;
    elseif (l(1)>true_l(1)+0.1)
      res = compare_impl(l,true_l(2:end)) ;
      res(3) = res(3) + 1 ;
    else
      res = compare_impl(l(2:end),true_l(2:end)) ;
      res(1) = res(1) + 1 ;
    end
  end
