function evaluate(proc,denoise,N,p,color)
  % Calcule, en fonction de la variance du bruit, l'erreur quadratique
  % moyenne produite par la fonction denoise. Affiche le resultat sur
  % la figure courante, en echelle logarithmique.

  % Parametres d'entree :
  %  - proc : fonction de generation d un processus aleatoire,
  %           qui prend en entree deux parametres (N et p)
  %  - denoise : la fonction de debruitage
  %  - N : taille des signaux
  %  - p : parametre du processus aleatoire
  %  - color (optionnel) : couleur de l'affichage

  noises = [0.1,0.3,1,3,10,30,100] * 10^(-2) ; % niveaux de bruits
  Kit = 10 ; % nombre d'echantillons pour le calcul de la moyenne

  mean_err = [] ; var_err = [] ;
  for s = noises
    sum_tmp = [] ;
    % calcul des echantillons pour le niveau de bruit courant
    for kit = 1:Kit
	x = proc(N,p) ;
	noise = randn(N,1) * s ;
	x_noisy = x + noise ;
	x_denoise = denoise(x_noisy,p,s) ;
	sum_tmp = [sum_tmp,norm(x-x_denoise,2)^2/N] ;
    end
    % moyenne
    mean_err(end+1) = mean(sum_tmp) ;
  end

  % affichage
  if (nargin<5)
    color = 'b' ;
  end
  hold on ;
  plot(noises,mean_err,'Marker','x','Color',color) ;
  set(gca,'XScale','log') ;
  set(gca,'YScale','log') ;
