clear all ; close all ;

% patches 16x16 de photographies en noir et blanc
load('patches.mat') ;
X = normalize(X) ;
draw_patches(X(:,1:25)) ;
print('patches_nb','-depsc') ;

K = 6 ; m = 64 ;
B = sparsify(X,m,K,100) ;
B = rearrange(X,B,K) ;

draw_patches(B) ;
print('patches_nb_basis','-depsc') ;


% patches 16x16 de photographies en couleurs
load('patches_color.mat') ;
X = normalize(X) ;
draw_patches(X(:,1:25)) ;
print('patches_color','-depsc') ;

K = 8 ; m = 81 ;
B = sparsify(X,m,K,40) ;
B = rearrange(X,B,K) ;

draw_patches(B) ;
print('patches_color_basis','-depsc') ;


% patches 16x16 d'images de BD en noir et blanc
load('patches_bd.mat') ;
X = normalize(X) ;
draw_patches(X(:,1:25)) ;
print('patches_bd','-depsc') ;

K = 6 ; m = 64 ;
B = sparsify(X,m,K,100) ;
B = rearrange(X,B,K) ;

draw_patches(B) ;
print('patches_bd_basis','-depsc') ;


% segments d'environ 100ms de morceaux de musique
load('audio_seg.mat') ;
X = normalize(X) ;
draw_functions(X(:,1:9)) ;
print('audio','-depsc') ;

K = 5 ; m = 64 ;
B = sparsify(X,m,K,20) ;
B = rearrange(X,B,K) ;

draw_functions(B(:,1:9)) ;
print('audio_basis','-depsc') ;


% donnees meteo (chaque vecteur est l'ensemble des valeurs moyennes
% par mois pendant un an dans une station meteo europeenne)
load('meteo.mat') ;
draw_functions(X(:,ceil(rand(1,9)*size(X,2)))) ;
print('meteo','-depsc') ;

K = 3 ; m = 6 ;
B = sparsify(X,m,K,50) ;
% multiplication des vecteurs par un signe, pour avoir un joli affichage
B = bsxfun(@times,B,sign(B(8,:)-B(1,:))) ;
B = rearrange(X,B,K) ;

draw_functions(B) ;
print('meteo_basis','-depsc') ;
