function y = sparse_coeffs(X,B,K)
  % 2.b) et 2.c) decomposition parcimonieuse des colonnes de X dans la
  % famille B

  n = size(X,1) ; m = size(B,2) ; p = size(X,2) ;
  % norme des colonnes de B
  % (le 1e-14 est la pour eviter des divisions par zero dans la suite)
  norms = sqrt(sum(abs(B).^2,1))+1e-14 ;

  % initialisation de y et r
  y = zeros(m,p) ;
  R = X ;
  for k=1:K
    % produits scalaires
    scals = B' * R ;
    scals_div = bsxfun(@rdivide,scals,norms') ;
    % indice maximal pour chaque colonne de R
    [oub,ind] = max(abs(scals),[],1) ;
    % remplacement des indices correspondants dans y
    ind_c = sub2ind(size(y),ind,[1:p]) ;
    scals_div2 = bsxfun(@rdivide,scals,(norms.^2)') ;
    y(ind_c) = y(ind_c) + scals_div2(ind_c) ;
    % mise a jour de r
    R = X - B * y ;
  end
