function [B,C] = sparsify(X,m,K,Nit)
  % 3.a) recherche d'une base parcimonieuse pour les colonnes de X

  % 3.b) initialisation de B
  n = size(X,1) ;
  B = randn(n,m) ;
  B = bsxfun(@rdivide,B,sqrt(sum(abs(B).^2,1))) ;

  for s=1:Nit
    % 3.c) on fixe B et on ajuste Y
    Y = sparse_coeffs(X,B,K) ;
    % 3.d) on fixe Y et on ajuste B
    B = X * pinv(Y) ;
    % normalisation de B
    % on commence par detecter les colonnes nulles et les remplacer
    % par un vecteur aleatoire, pour eviter de diviser par zero
    norms = sqrt(sum(abs(B).^2,1)) ;
    ind_zero = find(norms<1e-14) ;
    B(:,ind_zero) = randn(n,numel(ind_zero)) ;
    B = bsxfun(@rdivide,B,sqrt(sum(abs(B).^2,1))) ;
  end
  
  % affichage de l'ecart relatif entre X et BY
  diff = X-B*Y ;
  fprintf('Norme de X-BY par rapport a la norme de X : %f\n', ...
	  norm(diff(:))/norm(X(:))) ;
