function x_out = denoise_wiener(X_n,p,s)
  % 1.c) debruitage lineaire par le filtre de Wiener

  N = numel(X_n) ;

  % transformee de Fourier de l'autocorrelation de X
  R_X = p * (1 + 0.5*cos(2*pi*[0:N-1]'/N)).^2 ;
  % la transformee de Fourier de l'autocorrelation de N est s^2 ;
  % d'apres le cours, le filtre de Wiener a pour transformee de
  % Fourier R_X / (R_X+R_N)
  wiener_filter = R_X ./ (R_X + s^2) ;

  % convolution de X_n avec le filtre
  x_out = real(ifft(fft(X_n) .* wiener_filter)) ;
