function draw_patches(X)
  % affiche chaque colonne de X sous la forme d un patch carre

  % calcul de la taille des patches
  nb_p = size(X,2) ;
  n = sqrt(size(X,1)) ;
  if (abs(n-round(n))>1e-12)
     n = round(n / sqrt(3)) ;
     d = 3 ; % couleur
  else
    d = 1 ; % noir et blanc
  end

  % affichage
  figure()
  n_fig = ceil(sqrt(nb_p)) ;
  for k=1:nb_p
    subplot(n_fig,n_fig,k) ;
    patch = X(:,k) ;
    patch = reshape(patch,[n,n,d]) ;
    if (d==3)
      % normalisation pour l'affichage correct des patches couleur
      patch = patch - min(patch(:)) ;
      patch = patch / max(patch(:)) ;
    end
    imagesc(patch) ; colormap('gray') ;
    axis equal ; axis off ;
  end
