function x_out = denoise_nonlinear(X_n,p,s)
  % 1.g) debruitage non lineaire ; pour la description de
  % l'algorithme, voir le corrige

  N = numel(X_n) ;

  % calcul du filtre inverse de f
  f = zeros(N,1) ;
  f(1) = 1 ; f(2) = 0.25 ; f(end) = 0.25 ;
  g_fourier = 1./fft(f) ;
  X_deconv = real(ifft(fft(X_n) .* g_fourier)) ;

  % variance du bruit n star g
  lambda = s * sqrt(sum(abs(g_fourier).^2)/N) ;

  % seuillage
  thr = 3*lambda ;
  X_deconv(abs(X_deconv)<thr) = 0 ;
  X_deconv = X_deconv / (1+lambda^2) ;

  % convolution avec f
  x_out = real(ifft(fft(X_deconv).*fft(f))) ;
