function [im_comp,H] = compress(im,delta)

% transformee en ondelettes
[wt,aphi] = wavelet_transform(im) ;
v = [aphi,flatten(wt)] ;

% quantification
v_quant = round(v/delta) ;
im_comp = encode(v_quant) ;

% calcul de l'entropie
n_occ = hist(v_quant,[min(v_quant):max(v_quant)]) ;
freqs = n_occ(find(n_occ)) / numel(v_quant) ;
H = sum(-freqs.*log(freqs)/log(2)) ;

function v = flatten(wt)
% transforme un cell array de coefficients en un vecteur ligne
    
wt = cellfun(@(A)(A(:).'),wt,'UniformOutput',0) ;
v = cell2mat(wt) ;
