function [a,a_phi] = wavelet_transform(f)

[N,N2] = size(f) ;
if (N2 ~= N)
    error('last_scale : f doit etre une image carree') ;
end
J = round(log(N)/log(2)) ;
if (N ~= 2^J)
    error(['last_scale : la taille de f doit etre une puissance de ' ...
           '2']) ;
end

% a_phi est la somme de tous les elements de f, multipliee par 2^(-J)
a_phi = 2^(-J)*sum(f(:)) ;

% les autres coefficients sont calcules par une fonction auxiliaire
a = a_coeffs(f,J) ;



function a = a_coeffs(f,J)
% renvoie les produits scalaires de f et des fonctions psi, stockes
% dans un cell array
% J est l'entier tel que f est de taille 2^J x 2^J

if (J==0)
    a = {} ;
else
    % calcul pour j=1 et calcul de f tilde
    [a1,f_tilde] = last_scale(f) ;
    % calcul (recursif) des coefficients de f tilde dans la base
    % d'ondelettes de Haar
    a = a_coeffs(f_tilde,J-1) ;
    % concatenation de ces coefficients et de a1 pour former la
    % transformee en ondelettes de f
    a{J} = a1 ;
end