clear all ;
close all ;

im = imread('batiment_2.png') ;
im = double(im) ;
if (size(im,3)>1)
    % Pour Matlab
    im = mean(im,3) ;
end

% image initiale
figure (1) ;
imagesc(im,[0,255]) ; axis equal ;
colormap(gray(256)) ;

% delta = 100
figure (2) ;
imagesc(decompress(compress(im,100),100),[0,255]) ; axis equal ;
colormap(gray(256)) ;

% delta = 30
figure (3) ;
imagesc(decompress(compress(im,30),30),[0,255]) ; axis equal ;
colormap(gray(256)) ;

% calcul pour les huit valeurs de delta demandees ; c'est un peu lent.
deltas = [2,5,10,20,50,100,200,500] ;
for k=1:numel(deltas)
    [im_comp,h] = compress(im,deltas(k)) ;
    R(k) = numel(im_comp)/numel(im(:)) ;
    H(k) = h ;
    im_rec = decompress(im_comp,deltas(k)) ;
    D(k) = norm(im_rec(:)-im(:),2)^2 ;
end

% affichage des courbes
figure (4) ; hold on ;
plot(R,log(D)/log(2),'b') ;
plot(H,log(D)/log(2),'r') ;