function f = inverse_wavelet_transform(a,a_phi)
% renvoie la fonction f dont la transformee en ondelettes de Haar
% a pour coefficients a_phi et les elements de a

% N = 2^J
J = size(a,2) ;

if (J==0)
    % cas N=1
    
    f = a_phi ;

else
    % cas N>1
    
    % calcul de h
    a1 = a{J} ;
    h = zeros(2^J,2^J) ;
    h(1:2:end,1:2:end) = (a1(:,:,1)+a1(:,:,2)+a1(:,:,3))/2 ;
    h(2:2:end,1:2:end) = (a1(:,:,1)-a1(:,:,2)-a1(:,:,3))/2 ;
    h(1:2:end,2:2:end) = (-a1(:,:,1)+a1(:,:,2)-a1(:,:,3))/2 ;
    h(2:2:end,2:2:end) = (-a1(:,:,1)-a1(:,:,2)+a1(:,:,3))/2 ;    
    
    % calcul (par recurrence) de f tilde
    a_f_tilde = a(1:J-1) ;
    f_tilde = inverse_wavelet_transform(a_f_tilde,a_phi) ;

    % calcul de g
    g = zeros(2^J,2^J) ;
    g(1:2:end,1:2:end) = f_tilde/2 ;
    g(2:2:end,1:2:end) = f_tilde/2 ;
    g(1:2:end,2:2:end) = f_tilde/2 ;
    g(2:2:end,2:2:end) = f_tilde/2 ;
    
    % calcul de f
    f = g+h ;
    
end