function im_rec = decompress(im_comp,delta)

% decodage
wt_quant = decode(im_comp) ;
% coefficients en ondelettes (arrondis au multiple de delta le plus
% proche)
wt_flat = delta * wt_quant ;

% transformation du vecteur en un cell array de coefficients
aphi = wt_flat(1) ;
wt = deflatten(wt_flat(2:end)) ;

% reconstruction de l'image
im_rec = inverse_wavelet_transform(wt,aphi) ;

function wt = deflatten(wt_flat)
% inverse de flatten (voir compress.m)
    
nb_pixels = numel(wt_flat) + 1 ;
J = round(log(nb_pixels)/log(2)/2) ;

curr_index = 0 ;
for j=1:J
    nb_coeffs = 3*2^(2*(j-1)) ;
    wt{j} = reshape(wt_flat(curr_index+1:curr_index+nb_coeffs), ...
                    [2^(j-1),2^(j-1),3]) ;
    curr_index = curr_index + nb_coeffs ;
end
