function x = mp(A,b,K)
% implementation de la matching pursuit :
% on veut resoudre le probleme b = A*x avec x contenant le plus
% possible de coordonnees nulles

n = size(A,2) ;

norms = sqrt(sum(A.^2,1)) ;

% initialisation
r = b ;
x = zeros(1,n) ;

for k=1:K
    
    scals = r.'*A ;
    [forg,i_max] = max(abs(scals)./norms) ;
    
    x(i_max) = x(i_max) + scals(i_max)/norms(i_max)^2 ;
    r = r - A(:,i_max)*scals(i_max)/norms(i_max)^2 ;
    
end