close all ;
% generation du signal x
N = 200 ;
p = 0.02 ;
x = spikes(N,p) ;

% calcul de phi
N2 = 30 ;
ks = [0:N2]' ; ks2 = [N2:(-1):1]' ;
phi_f = [(N2-ks).^2.*(N2+ks).^2;
         zeros(N-2*N2-1,1);
         (N2-ks2).^2.*(N2+ks2).^2] ;
phi = ifft(phi_f) ;
phi = phi/max(phi) ;

% convolution
x_conv = real(ifft(fft(x).*fft(phi))) ;

% affichage
figure (1) ; clf ; hold on ;
plot(x) ;
plot(x_conv,'r') ;

% calcul de A
A = eye(N) ; % chaque colonne est un dirac
A = fft(A) ; % chaque colonne est la transformee de Fourier d'un dirac
A = bsxfun(@times,A,fft(phi)) ; % chaque colonne est la transformee
                                % de Fourier d'un dirac, multipliee
                                % par la transformee de Fourier de phi
A = real(ifft(A)) ; % chaque colonne est la convolution d'un dirac
                    % par phi

% reconstruction
K = floor(2*p*N) ; % nombre d'iterations
x_rec = mp(A,x_conv,K) ;

% affichage
figure (2) ; clf ; hold on ;
plot(x) ;
plot(x_rec,'r') ;

% Test pour x une somme de diracs
esps = [8,9] ;
for k=1:numel(esps)
    % generation du signal x
    x = zeros(N,1) ;
    x(100) = 1 ; x(100+esps(k)) = 1 ;
    % convolution
    x_conv = real(ifft(fft(x).*fft(phi))) ;
    % reconstruction
    K = 3 ; % nombre d'iterations
    x_rec = mp(A,x_conv,K) ;
    
    % affichage
    figure (k+2) ; clf ; hold on ;
    plot(x) ;
    plot(x_rec,'r') ;
    title(sprintf('Deux diracs espaces de %d',esps(k))) ;
end

% pour N2 = 30, les diracs sont reconstruits s'ils sont espaces
%    d'au moins 9 unites
% pour N2 = 15, il faut 19 unites
% pour N2 = 10, il faut 28
% cet espacement est à peu près égal à la largeur caractéristique
% de phi : tant que l'ecart entre les diracs est superieur a cette
% largeur, x star phi contient deux pics bien visibles et on peut
% reconstruire la position respective des deux diracs. Lorsque
% l'ecart devient plus petit, les deux pics se mélangent et la
% reconstruction devient plus difficile.